/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.teastory.fluid;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import xueluoanping.teastory.TeaStory;
import xueluoanping.teastory.registry.FluidRegistry;

public class HotWaterFlowingFluidBlock
extends LiquidBlock {
    public static final ResourceKey<DamageType> BOILING = HotWaterFlowingFluidBlock.register("boiling");

    private static ResourceKey<DamageType> register(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)TeaStory.rl(name));
    }

    public static DamageSource getBoiling(Level level) {
        return new DamageSource((Holder)level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(BOILING));
    }

    public HotWaterFlowingFluidBlock(Supplier<? extends FlowingFluid> supplier, BlockBehaviour.Properties copy) {
        super(supplier, copy);
    }

    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        double d0 = (double)pos.m_123341_() + 0.5;
        double d1 = (double)pos.m_123342_() + rand.m_188500_() * 6.0 / 16.0;
        double d2 = (double)pos.m_123343_() + 0.5;
        double d4 = rand.m_188500_() * 0.6 - 0.3;
        if (this.getFluid().getFluidType().getTemperature() >= 373) {
            worldIn.m_6493_((ParticleOptions)ParticleTypes.f_123795_, false, d0 + d4, d1, d2 + d4, 0.0, 0.5, 0.0);
            if (rand.m_188503_(32) == 0) {
                worldIn.m_6263_((Player)null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11774_, SoundSource.BLOCKS, rand.m_188501_() * 0.25f + 0.75f, 0.1f);
            }
        }
        if (worldIn.m_46859_(pos.m_7494_()) && (float)(this.getFluid().getFluidType().getTemperature() - 273) / 100.0f >= rand.m_188501_()) {
            worldIn.m_6493_((ParticleOptions)ParticleTypes.f_123796_, false, d0 + d4, d1 + 1.25, d2 + d4, 0.0, 0.1, 0.0);
        }
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity) {
            if (this.getFluid().getFluidType().getTemperature() >= 373) {
                entityIn.m_6469_(HotWaterFlowingFluidBlock.getBoiling(worldIn), 4.0f);
            } else if (this.getFluid().getFluidType().getTemperature() >= 353) {
                entityIn.m_6469_(HotWaterFlowingFluidBlock.getBoiling(worldIn), 2.0f);
            } else if (this.getFluid().getFluidType().getTemperature() >= 318) {
                entityIn.m_6469_(HotWaterFlowingFluidBlock.getBoiling(worldIn), 1.0f);
            } else {
                ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19605_, 40, 0));
            }
        }
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (!(state.m_60734_() == FluidRegistry.WARM_WATER.get() && worldIn.m_8055_(pos.m_6625_(2)).m_60734_() instanceof CampfireBlock || state.m_60819_().m_76186_() != 8 || random.m_188503_(10) != 0)) {
            if (state.m_60819_().getFluidType().getTemperature() >= 373) {
                worldIn.m_46597_(pos, ((LiquidBlock)FluidRegistry.HOT_WATER_80.get()).m_49966_());
            } else if (state.m_60819_().getFluidType().getTemperature() >= 353) {
                worldIn.m_46597_(pos, ((LiquidBlock)FluidRegistry.HOT_WATER_60.get()).m_49966_());
            } else if (state.m_60819_().getFluidType().getTemperature() >= 318) {
                worldIn.m_46597_(pos, ((LiquidBlock)FluidRegistry.WARM_WATER.get()).m_49966_());
            } else {
                worldIn.m_46597_(pos, Blocks.f_49990_.m_49966_());
            }
        }
    }
}

